/*
 * Decompiled with CFR 0.152.
 */
package imex.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Random;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class UserInterface
implements ActionListener,
ItemListener {
    private JFrame mainFrame;
    private JPanel topPanel;
    private JPanel middlePanel;
    private JPanel bottomPanel;
    private JPanel basicMiddlePanel;
    private JPanel intermediateMiddlePanel;
    private JPanel advancedMiddlePanel;
    private JLabel repeatTypeLabel;
    private JLabel repeatSizeLabel;
    private JLabel parameterSetLabel;
    private JLabel mainParametersLabel;
    private JLabel repeatSizeLabe;
    private JLabel maxDistanceLabel;
    private JLabel maxDistanceLimitLabel;
    private JComboBox modeComboBox;
    private JComboBox repeatTypeComboBox;
    private JComboBox repeatSizeComboBox;
    private JComboBox[] imperfectionPercentageComboBox;
    private JComboBox[] imperfectionLimitComboBox;
    private JComboBox flankingComboBox;
    private JComboBox standardizationComboBox;
    private JCheckBox pttFileUploadBox;
    private JCheckBox flankingBox;
    private JCheckBox alignmentBox;
    private JCheckBox textOutputBox;
    private JCheckBox compoundBox;
    private JCheckBox standardizationBox;
    private JTextField sequenceFileLocationField;
    private JTextField pttFileLocationField;
    private JTextField[] repeatNumberField;
    private JTextField maxDistanceField;
    private JTextArea sequenceText;
    private JButton sequenceFileUploadBrowseButton;
    private JButton repeatNumberButton;
    private JButton imperfectionLimitButton;
    private JButton imperfectionPercentageButton;
    private JButton pttFileUploadBrowseButton;
    private JButton pttLinkButton;
    private ButtonGroup sequenceSelectionGroup;
    private JRadioButton sequenceFileUploadRadioButton;
    private JRadioButton pasteRadioButton;
    private String[] repeatTypes = new String[]{"Imperfect", "Perfect"};
    private String[] repeatSizes = new String[]{"All", "Mono", "Di", "Tri", "Tetra", "Penta", "Hexa"};
    private String[] imperfectionPercentages = new String[]{"0%", "5%", "10%", "15%", "20%", "25%", "30%", "35%", "40%", "45%", "50%"};
    private String[][] imperfectionLimits = new String[][]{{"0", "1"}, {"0", "1", "2"}, {"0", "1", "2", "3"}, {"0", "1", "2", "3", "4"}, {"0", "1", "2", "3", "4", "5"}, {"0", "1", "2", "3", "4", "5", "6"}};
    private String[] flankingValues = new String[]{"5", "10", "15", "20", "30", "40", "50", "100", "150", "200"};
    private String[] standardizationLevels = new String[]{"No Standardization", "Level 1 Standardization", "Level 2 Standardization", "Level 3 Standardization", "Full / Complete Standardization"};
    private String currentMode;
    private String currentRepeatType;

    public void showScreen() {
        this.createTopPanel();
        this.createAdvancedMiddlePanel();
        this.createBottomPanel();
        this.middlePanel = this.advancedMiddlePanel;
        this.currentMode = "Advanced";
        this.currentRepeatType = "Imperfect";
        JScrollBar jScrollBar = new JScrollBar(1);
        this.mainFrame = new JFrame("IMEx");
        this.mainFrame.setLayout(null);
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.add(this.topPanel);
        this.mainFrame.add(this.middlePanel);
        this.mainFrame.add(this.bottomPanel);
        this.mainFrame.add(jScrollBar);
        this.mainFrame.setBounds(200, 0, 695, 700);
        this.mainFrame.setResizable(false);
        this.mainFrame.setVisible(true);
    }

    protected void createTopPanel() {
        String[] stringArray = new String[]{"Basic", "Intermediate", "Advanced"};
        JLabel jLabel = new JLabel("IMEx Mode: ");
        JLabel jLabel2 = new JLabel("<html><font face = 'Arial' color = '#a00000' size = '2'>The Sequence file should be in FASTA or Plain Format</font></html>");
        this.modeComboBox = new JComboBox<String>(stringArray);
        this.modeComboBox.setSelectedIndex(2);
        this.sequenceFileUploadBrowseButton = new JButton("Browse");
        JButton jButton = new JButton("Sample Sequence");
        this.sequenceFileLocationField = new JTextField();
        this.sequenceText = new JTextArea();
        this.sequenceText.setFont(new Font("Monospaced", 0, 14));
        this.sequenceText.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.sequenceText);
        this.sequenceFileUploadRadioButton = new JRadioButton("Upload a file from your directory", true);
        this.pasteRadioButton = new JRadioButton("Cut and Paste your sequence", false);
        this.sequenceSelectionGroup = new ButtonGroup();
        this.sequenceSelectionGroup.add(this.sequenceFileUploadRadioButton);
        this.sequenceSelectionGroup.add(this.pasteRadioButton);
        this.sequenceFileUploadRadioButton.setBackground(new Color(245, 245, 245));
        this.pasteRadioButton.setBackground(new Color(245, 245, 245));
        this.modeComboBox.setActionCommand("IMEx Mode");
        this.sequenceFileUploadBrowseButton.setActionCommand("Sequence File Browse");
        jButton.setActionCommand("Sample Sequence");
        this.modeComboBox.addActionListener(this);
        this.sequenceFileUploadBrowseButton.addActionListener(this);
        jButton.addActionListener(this);
        this.modeComboBox.addActionListener(this);
        this.sequenceFileUploadRadioButton.addItemListener(this);
        this.pasteRadioButton.addItemListener(this);
        jLabel.setBounds(465, 10, 85, 20);
        this.modeComboBox.setBounds(555, 10, 120, 20);
        jLabel2.setBounds(10, 35, 400, 20);
        this.sequenceFileUploadRadioButton.setBounds(10, 60, 300, 20);
        this.sequenceFileLocationField.setBounds(10, 85, 140, 20);
        this.sequenceFileUploadBrowseButton.setBounds(160, 85, 90, 20);
        jButton.setBounds(510, 85, 165, 20);
        this.pasteRadioButton.setBounds(10, 115, 250, 20);
        jScrollPane.setBounds(10, 140, 665, 110);
        this.topPanel = new JPanel();
        this.topPanel.setLayout(null);
        this.topPanel.add(jLabel);
        this.topPanel.add(this.modeComboBox);
        this.topPanel.add(jLabel2);
        this.topPanel.add(this.sequenceFileUploadRadioButton);
        this.topPanel.add(this.sequenceFileLocationField);
        this.topPanel.add(this.sequenceFileUploadBrowseButton);
        this.topPanel.add(jButton);
        this.topPanel.add(this.pasteRadioButton);
        this.topPanel.add(jScrollPane);
        this.topPanel.setBounds(0, 0, 690, 260);
        this.topPanel.setBackground(new Color(245, 245, 245));
    }

    protected void createBasicMiddlePanel() {
        this.repeatTypeLabel = new JLabel("Type of Repeat: ");
        this.repeatTypeComboBox = new JComboBox<String>(this.repeatTypes);
        this.repeatTypeComboBox.setSelectedIndex(0);
        this.pttFileUploadBox = new JCheckBox("Upload Coding info file:", false);
        this.pttFileUploadBox.setBackground(new Color(245, 245, 245));
        this.pttLinkButton = new JButton("<html><font face = 'Arial' color = '#a00000'>(.ptt)</font></html>");
        this.pttLinkButton.setBorderPainted(false);
        this.pttLinkButton.setContentAreaFilled(false);
        this.pttLinkButton.setToolTipText("Upload the NCBI's Protein Table File (.ptt)");
        this.pttFileLocationField = new JTextField();
        this.pttFileUploadBrowseButton = new JButton("Browse");
        this.pttFileLocationField.setEnabled(false);
        this.pttFileUploadBrowseButton.setEnabled(false);
        JLabel jLabel = new JLabel("<html><font face = 'Arial' color = '#a00000'>*</font> Note the basic mode uses </html>");
        JLabel jLabel2 = new JLabel(" of IMEx.");
        JButton jButton = new JButton("<html><font face = 'Arial' color = '#a00000'>default parameters</font></html>");
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        this.pttFileUploadBrowseButton.setActionCommand("Ptt File Browse");
        this.pttLinkButton.setActionCommand("Ptt Info");
        jButton.setActionCommand("Default Parameters Info");
        this.pttFileUploadBrowseButton.addActionListener(this);
        this.pttLinkButton.addActionListener(this);
        jButton.addActionListener(this);
        this.pttFileUploadBox.addItemListener(this);
        this.repeatTypeLabel.setBounds(10, 10, 125, 20);
        this.repeatTypeComboBox.setBounds(140, 10, 100, 20);
        this.pttFileUploadBox.setBounds(10, 40, 194, 20);
        this.pttLinkButton.setBounds(186, 40, 55, 20);
        this.pttFileLocationField.setBounds(245, 40, 140, 20);
        this.pttFileUploadBrowseButton.setBounds(390, 40, 90, 20);
        jLabel.setBounds(10, 70, 200, 20);
        jButton.setBounds(195, 70, 180, 20);
        jLabel2.setBounds(358, 70, 60, 20);
        this.basicMiddlePanel = new JPanel();
        this.basicMiddlePanel.setLayout(null);
        this.basicMiddlePanel.add(this.repeatTypeLabel);
        this.basicMiddlePanel.add(this.repeatTypeComboBox);
        this.basicMiddlePanel.add(this.pttFileUploadBox);
        this.basicMiddlePanel.add(this.pttLinkButton);
        this.basicMiddlePanel.add(this.pttFileLocationField);
        this.basicMiddlePanel.add(this.pttFileUploadBrowseButton);
        this.basicMiddlePanel.add(jLabel);
        this.basicMiddlePanel.add(jButton);
        this.basicMiddlePanel.add(jLabel2);
        this.basicMiddlePanel.setBounds(0, 260, 690, 105);
        this.basicMiddlePanel.setBackground(new Color(245, 245, 245));
    }

    protected void createIntermediateMiddlePanel() {
        int n;
        int n2;
        this.repeatTypeLabel = new JLabel("Type of Repeat: ");
        this.repeatTypeComboBox = new JComboBox<String>(this.repeatTypes);
        this.repeatTypeComboBox.setSelectedIndex(0);
        this.repeatSizeLabel = new JLabel("Repeat Size: ");
        this.repeatSizeComboBox = new JComboBox<String>(this.repeatSizes);
        this.repeatSizeComboBox.setSelectedIndex(0);
        JLabel jLabel = new JLabel("Imperfection %: ");
        this.imperfectionPercentageComboBox = new JComboBox[1];
        this.imperfectionPercentageComboBox[0] = new JComboBox<String>(this.imperfectionPercentages);
        this.imperfectionPercentageComboBox[0].setSelectedIndex(2);
        JLabel[] jLabelArray = new JLabel[]{new JLabel("Main parameters"), new JLabel("Mono"), new JLabel("Di"), new JLabel("Tri"), new JLabel("Tetra"), new JLabel("Penta"), new JLabel("Hexa")};
        for (n2 = 0; n2 < 7; ++n2) {
            jLabelArray[n2].setHorizontalAlignment(0);
        }
        this.repeatNumberButton = new JButton("<html><font face = 'Arial' color = '#a00000'>Minimum Repeat Number: </font></html>");
        this.repeatNumberButton.setContentAreaFilled(false);
        this.repeatNumberButton.setHorizontalAlignment(2);
        this.repeatNumberButton.setToolTipText("Minimum number of repeat units to be reported as a valid microsatellite");
        this.repeatNumberField = new JTextField[6];
        this.repeatNumberField[0] = new JTextField("15");
        this.repeatNumberField[1] = new JTextField("7");
        this.repeatNumberField[2] = new JTextField("5");
        this.repeatNumberField[3] = new JTextField("4");
        this.repeatNumberField[4] = new JTextField("3");
        this.repeatNumberField[5] = new JTextField("3");
        this.imperfectionLimitButton = new JButton("<html><font face = 'Arial' color = '#a00000'>Imperfection Limit/repeat unit: </font></html>");
        this.imperfectionLimitButton.setHorizontalAlignment(2);
        this.imperfectionLimitButton.setContentAreaFilled(false);
        this.imperfectionLimitButton.setToolTipText("Minimum Number of point mutations that can be allowed in a repeat unit to be considered as a matching repeat unit");
        this.imperfectionLimitComboBox = new JComboBox[6];
        this.imperfectionLimitComboBox[0] = new JComboBox<String>(this.imperfectionLimits[0]);
        this.imperfectionLimitComboBox[1] = new JComboBox<String>(this.imperfectionLimits[1]);
        this.imperfectionLimitComboBox[2] = new JComboBox<String>(this.imperfectionLimits[2]);
        this.imperfectionLimitComboBox[3] = new JComboBox<String>(this.imperfectionLimits[3]);
        this.imperfectionLimitComboBox[4] = new JComboBox<String>(this.imperfectionLimits[4]);
        this.imperfectionLimitComboBox[5] = new JComboBox<String>(this.imperfectionLimits[5]);
        this.imperfectionLimitComboBox[0].setSelectedIndex(1);
        this.imperfectionLimitComboBox[1].setSelectedIndex(1);
        this.imperfectionLimitComboBox[2].setSelectedIndex(1);
        this.imperfectionLimitComboBox[3].setSelectedIndex(2);
        this.imperfectionLimitComboBox[4].setSelectedIndex(2);
        this.imperfectionLimitComboBox[5].setSelectedIndex(3);
        for (n2 = 0; n2 < 6; ++n2) {
            jLabelArray[n2 + 1].setBounds(240 + n2 * 70 + 5, 0, 70, 30);
            jLabelArray[n2 + 1].setBorder(new EtchedBorder(0));
            this.repeatNumberField[n2].setBounds(240 + n2 * 70 + 5, 30, 70, 30);
            this.repeatNumberField[n2].setBorder(new EtchedBorder(0));
            this.imperfectionLimitComboBox[n2].setBounds(240 + n2 * 70 + 5, 60, 70, 30);
            this.imperfectionLimitComboBox[n2].setBorder(new EtchedBorder(0));
        }
        jLabelArray[0].setBounds(0, 0, 245, 30);
        jLabelArray[0].setBorder(new EtchedBorder(0));
        this.repeatNumberButton.setBounds(0, 30, 245, 30);
        this.repeatNumberButton.setBorder(new EtchedBorder(0));
        this.imperfectionLimitButton.setBounds(0, 60, 245, 30);
        this.imperfectionLimitButton.setBorder(new EtchedBorder(0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setBackground(new Color(245, 245, 245));
        for (n = 0; n < 7; ++n) {
            jPanel.add(jLabelArray[n]);
        }
        jPanel.add(this.repeatNumberButton);
        for (n = 0; n < 6; ++n) {
            jPanel.add(this.repeatNumberField[n]);
        }
        jPanel.add(this.imperfectionLimitButton);
        for (n = 0; n < 6; ++n) {
            jPanel.add(this.imperfectionLimitComboBox[n]);
        }
        this.pttFileUploadBox = new JCheckBox("Upload Coding info file:", false);
        this.pttFileUploadBox.setBackground(new Color(245, 245, 245));
        this.pttLinkButton = new JButton("<html><font face = 'Arial' color = '#a00000'>(.ptt)</font></html>");
        this.pttLinkButton.setBorderPainted(false);
        this.pttLinkButton.setContentAreaFilled(false);
        this.pttLinkButton.setToolTipText("Upload the NCBI's Protein Table File (.ptt)");
        this.pttFileLocationField = new JTextField();
        this.pttFileUploadBrowseButton = new JButton("Browse");
        this.pttFileLocationField.setEnabled(false);
        this.pttFileUploadBrowseButton.setEnabled(false);
        this.repeatTypeComboBox.setActionCommand("Repeat Type");
        this.repeatNumberButton.setActionCommand("Minimum Repeat Number Info");
        this.imperfectionLimitButton.setActionCommand("Imperfection Limit Info");
        this.pttFileUploadBrowseButton.setActionCommand("Ptt File Browse");
        this.pttLinkButton.setActionCommand("Ptt Info");
        this.repeatTypeComboBox.addActionListener(this);
        this.repeatNumberButton.addActionListener(this);
        this.imperfectionLimitButton.addActionListener(this);
        this.pttFileUploadBrowseButton.addActionListener(this);
        this.pttLinkButton.addActionListener(this);
        this.pttFileUploadBox.addItemListener(this);
        this.repeatTypeLabel.setBounds(10, 10, 125, 20);
        this.repeatTypeComboBox.setBounds(140, 10, 100, 20);
        this.repeatSizeLabel.setBounds(250, 10, 95, 20);
        this.repeatSizeComboBox.setBounds(350, 10, 70, 20);
        jLabel.setBounds(430, 10, 120, 20);
        this.imperfectionPercentageComboBox[0].setBounds(550, 10, 60, 20);
        jPanel.setBounds(10, 50, 665, 90);
        this.pttFileUploadBox.setBounds(10, 160, 194, 20);
        this.pttLinkButton.setBounds(186, 160, 55, 20);
        this.pttFileLocationField.setBounds(245, 160, 140, 20);
        this.pttFileUploadBrowseButton.setBounds(390, 160, 90, 20);
        this.intermediateMiddlePanel = new JPanel();
        this.intermediateMiddlePanel.setLayout(null);
        this.intermediateMiddlePanel.add(this.repeatTypeLabel);
        this.intermediateMiddlePanel.add(this.repeatTypeComboBox);
        this.intermediateMiddlePanel.add(this.repeatSizeLabel);
        this.intermediateMiddlePanel.add(this.repeatSizeComboBox);
        this.intermediateMiddlePanel.add(jLabel);
        this.intermediateMiddlePanel.add(this.imperfectionPercentageComboBox[0]);
        this.intermediateMiddlePanel.add(jPanel);
        this.intermediateMiddlePanel.add(this.pttFileUploadBox);
        this.intermediateMiddlePanel.add(this.pttLinkButton);
        this.intermediateMiddlePanel.add(this.pttFileLocationField);
        this.intermediateMiddlePanel.add(this.pttFileUploadBrowseButton);
        this.intermediateMiddlePanel.setBounds(0, 260, 690, 195);
        this.intermediateMiddlePanel.setBackground(new Color(245, 245, 245));
    }

    protected void createAdvancedMiddlePanel() {
        int n;
        int n2;
        this.parameterSetLabel = new JLabel("<html><font face = 'Arial' color = '#a00000' size = '2'>Set the parameters here:</font></html>");
        this.flankingBox = new JCheckBox("Include Flanking regions", true);
        this.flankingBox.setBackground(new Color(245, 245, 245));
        this.flankingComboBox = new JComboBox<String>(this.flankingValues);
        this.flankingComboBox.setSelectedIndex(1);
        this.alignmentBox = new JCheckBox("Generate Alignments", true);
        this.alignmentBox.setBackground(new Color(245, 245, 245));
        this.textOutputBox = new JCheckBox("Generate Text output files", false);
        this.textOutputBox.setBackground(new Color(245, 245, 245));
        this.repeatTypeLabel = new JLabel("Type of Repeat: ");
        this.repeatTypeComboBox = new JComboBox<String>(this.repeatTypes);
        this.repeatTypeComboBox.setSelectedIndex(0);
        this.repeatSizeLabel = new JLabel("Repeat Size: ");
        this.repeatSizeComboBox = new JComboBox<String>(this.repeatSizes);
        JLabel[] jLabelArray = new JLabel[]{new JLabel("Main parameters"), new JLabel("Mono"), new JLabel("Di"), new JLabel("Tri"), new JLabel("Tetra"), new JLabel("Penta"), new JLabel("Hexa")};
        for (n2 = 0; n2 < 7; ++n2) {
            jLabelArray[n2].setHorizontalAlignment(0);
        }
        this.repeatNumberButton = new JButton("<html><font face = 'Arial' color = '#a00000'>Minimum Repeat Number: </font></html>");
        this.repeatNumberButton.setContentAreaFilled(false);
        this.repeatNumberButton.setHorizontalAlignment(2);
        this.repeatNumberButton.setToolTipText("Minimum number of repeat units to be reported as a valid microsatellite");
        this.repeatNumberField = new JTextField[6];
        this.repeatNumberField[0] = new JTextField("15");
        this.repeatNumberField[1] = new JTextField("7");
        this.repeatNumberField[2] = new JTextField("5");
        this.repeatNumberField[3] = new JTextField("4");
        this.repeatNumberField[4] = new JTextField("3");
        this.repeatNumberField[5] = new JTextField("3");
        this.imperfectionLimitButton = new JButton("<html><font face = 'Arial' color = '#a00000'>Imperfection Limit/repeat unit: </font></html>");
        this.imperfectionLimitButton.setHorizontalAlignment(2);
        this.imperfectionLimitButton.setContentAreaFilled(false);
        this.imperfectionLimitButton.setToolTipText("Minimum Number of point mutations that can be allowed in a repeat unit to be considered as a matching repeat unit");
        this.imperfectionLimitComboBox = new JComboBox[6];
        this.imperfectionLimitComboBox[0] = new JComboBox<String>(this.imperfectionLimits[0]);
        this.imperfectionLimitComboBox[1] = new JComboBox<String>(this.imperfectionLimits[1]);
        this.imperfectionLimitComboBox[2] = new JComboBox<String>(this.imperfectionLimits[2]);
        this.imperfectionLimitComboBox[3] = new JComboBox<String>(this.imperfectionLimits[3]);
        this.imperfectionLimitComboBox[4] = new JComboBox<String>(this.imperfectionLimits[4]);
        this.imperfectionLimitComboBox[5] = new JComboBox<String>(this.imperfectionLimits[5]);
        this.imperfectionLimitComboBox[0].setSelectedIndex(1);
        this.imperfectionLimitComboBox[1].setSelectedIndex(1);
        this.imperfectionLimitComboBox[2].setSelectedIndex(1);
        this.imperfectionLimitComboBox[3].setSelectedIndex(2);
        this.imperfectionLimitComboBox[4].setSelectedIndex(2);
        this.imperfectionLimitComboBox[5].setSelectedIndex(3);
        this.imperfectionPercentageButton = new JButton("<html><font face = 'Arial' color = '#a00000'>% Imperfection in Repeat Tract: </font></html>");
        this.imperfectionPercentageButton.setHorizontalAlignment(2);
        this.imperfectionPercentageButton.setContentAreaFilled(false);
        this.imperfectionPercentageButton.setToolTipText("Maximum Percentage of Mismatches in the repeat tract");
        this.imperfectionPercentageComboBox = new JComboBox[6];
        for (n2 = 0; n2 < 6; ++n2) {
            this.imperfectionPercentageComboBox[n2] = new JComboBox<String>(this.imperfectionPercentages);
            this.imperfectionPercentageComboBox[n2].setSelectedIndex(2);
        }
        for (n2 = 0; n2 < 6; ++n2) {
            jLabelArray[n2 + 1].setBounds(240 + n2 * 70 + 5, 0, 70, 30);
            jLabelArray[n2 + 1].setBorder(new EtchedBorder(0));
            this.repeatNumberField[n2].setBounds(240 + n2 * 70 + 5, 30, 70, 30);
            this.repeatNumberField[n2].setBorder(new EtchedBorder(0));
            this.imperfectionLimitComboBox[n2].setBounds(240 + n2 * 70 + 5, 60, 70, 30);
            this.imperfectionLimitComboBox[n2].setBorder(new EtchedBorder(0));
            this.imperfectionPercentageComboBox[n2].setBounds(240 + n2 * 70 + 5, 90, 70, 30);
            this.imperfectionPercentageComboBox[n2].setBorder(new EtchedBorder(0));
        }
        jLabelArray[0].setBounds(0, 0, 245, 30);
        jLabelArray[0].setBorder(new EtchedBorder(0));
        this.repeatNumberButton.setBounds(0, 30, 245, 30);
        this.repeatNumberButton.setBorder(new EtchedBorder(0));
        this.imperfectionLimitButton.setBounds(0, 60, 245, 30);
        this.imperfectionLimitButton.setBorder(new EtchedBorder(0));
        this.imperfectionPercentageButton.setBounds(0, 90, 245, 30);
        this.imperfectionPercentageButton.setBorder(new EtchedBorder(0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setBackground(new Color(245, 245, 245));
        for (n = 0; n < 7; ++n) {
            jPanel.add(jLabelArray[n]);
        }
        jPanel.add(this.repeatNumberButton);
        for (n = 0; n < 6; ++n) {
            jPanel.add(this.repeatNumberField[n]);
        }
        jPanel.add(this.imperfectionLimitButton);
        for (n = 0; n < 6; ++n) {
            jPanel.add(this.imperfectionLimitComboBox[n]);
        }
        jPanel.add(this.imperfectionPercentageButton);
        for (n = 0; n < 6; ++n) {
            jPanel.add(this.imperfectionPercentageComboBox[n]);
        }
        this.pttFileUploadBox = new JCheckBox("Upload Coding info file:", false);
        this.pttFileUploadBox.setBackground(new Color(245, 245, 245));
        this.pttLinkButton = new JButton("<html><font face = 'Arial' color = '#a00000'>(.ptt)</font></html>");
        this.pttLinkButton.setBorderPainted(false);
        this.pttLinkButton.setContentAreaFilled(false);
        this.pttLinkButton.setToolTipText("Upload the NCBI's Protein Table File (.ptt)");
        this.pttFileLocationField = new JTextField();
        this.pttFileUploadBrowseButton = new JButton("Browse");
        this.pttFileLocationField.setEnabled(false);
        this.pttFileUploadBrowseButton.setEnabled(false);
        this.compoundBox = new JCheckBox("Extract Compound Microsatellites", false);
        this.compoundBox.setBackground(new Color(245, 245, 245));
        this.maxDistanceLabel = new JLabel("Max. distance allowed between two SSRs");
        JButton jButton = new JButton("<html><font face = 'Arial' color = '#a00000'>(dMax)</font></html>");
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        this.maxDistanceField = new JTextField("10");
        this.maxDistanceLimitLabel = new JLabel("(0-50)");
        this.maxDistanceField.setEnabled(false);
        this.standardizationBox = new JCheckBox();
        JButton jButton2 = new JButton("<html><font face = 'arial' color = '#a00000'>Level of Standardization:</font></html>");
        jButton2.setBorderPainted(false);
        jButton2.setContentAreaFilled(false);
        jButton2.setToolTipText("Select the level of standardization");
        this.standardizationComboBox = new JComboBox<String>(this.standardizationLevels);
        this.standardizationComboBox.setSelectedIndex(0);
        this.standardizationComboBox.setEnabled(false);
        this.repeatTypeComboBox.setActionCommand("Repeat Type");
        this.repeatNumberButton.setActionCommand("Minimum Repeat Number Info");
        this.imperfectionLimitButton.setActionCommand("Imperfection Limit Info");
        this.imperfectionPercentageButton.setActionCommand("Imperfection Percentage Info");
        this.pttFileUploadBrowseButton.setActionCommand("Ptt File Browse");
        this.pttLinkButton.setActionCommand("Ptt Info");
        jButton.setActionCommand("dMax Info");
        jButton2.setActionCommand("Standardization Info");
        this.repeatTypeComboBox.addActionListener(this);
        this.repeatNumberButton.addActionListener(this);
        this.imperfectionLimitButton.addActionListener(this);
        this.imperfectionPercentageButton.addActionListener(this);
        this.pttFileUploadBrowseButton.addActionListener(this);
        this.pttLinkButton.addActionListener(this);
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        this.flankingBox.addItemListener(this);
        this.pttFileUploadBox.addItemListener(this);
        this.compoundBox.addItemListener(this);
        this.standardizationBox.addItemListener(this);
        this.parameterSetLabel.setBounds(10, 10, 195, 20);
        this.flankingBox.setBounds(10, 40, 200, 20);
        this.flankingComboBox.setBounds(215, 40, 50, 20);
        this.alignmentBox.setBounds(275, 40, 180, 20);
        this.textOutputBox.setBounds(460, 40, 230, 20);
        this.repeatTypeLabel.setBounds(10, 70, 125, 20);
        this.repeatTypeComboBox.setBounds(140, 70, 100, 20);
        this.repeatSizeLabel.setBounds(250, 70, 100, 20);
        this.repeatSizeComboBox.setBounds(355, 70, 70, 20);
        jPanel.setBounds(10, 110, 665, 120);
        this.pttFileUploadBox.setBounds(10, 250, 194, 20);
        this.pttLinkButton.setBounds(186, 250, 55, 20);
        this.pttFileLocationField.setBounds(245, 250, 140, 20);
        this.pttFileUploadBrowseButton.setBounds(390, 250, 90, 20);
        this.compoundBox.setBounds(10, 280, 280, 20);
        this.maxDistanceLabel.setBounds(35, 305, 300, 20);
        jButton.setBounds(318, 305, 70, 20);
        this.maxDistanceField.setBounds(390, 305, 25, 20);
        this.maxDistanceLimitLabel.setBounds(420, 305, 50, 20);
        this.standardizationBox.setBounds(10, 340, 20, 20);
        jButton2.setBounds(15, 340, 220, 20);
        this.standardizationComboBox.setBounds(225, 340, 255, 20);
        this.advancedMiddlePanel = new JPanel();
        this.advancedMiddlePanel.setLayout(null);
        this.advancedMiddlePanel.add(this.parameterSetLabel);
        this.advancedMiddlePanel.add(this.flankingBox);
        this.advancedMiddlePanel.add(this.flankingComboBox);
        this.advancedMiddlePanel.add(this.alignmentBox);
        this.advancedMiddlePanel.add(this.textOutputBox);
        this.advancedMiddlePanel.add(this.repeatTypeLabel);
        this.advancedMiddlePanel.add(this.repeatTypeComboBox);
        this.advancedMiddlePanel.add(this.repeatSizeLabel);
        this.advancedMiddlePanel.add(this.repeatSizeComboBox);
        this.advancedMiddlePanel.add(jPanel);
        this.advancedMiddlePanel.add(this.pttFileUploadBox);
        this.advancedMiddlePanel.add(this.pttLinkButton);
        this.advancedMiddlePanel.add(this.pttFileLocationField);
        this.advancedMiddlePanel.add(this.pttFileUploadBrowseButton);
        this.advancedMiddlePanel.add(this.compoundBox);
        this.advancedMiddlePanel.add(this.maxDistanceLabel);
        this.advancedMiddlePanel.add(jButton);
        this.advancedMiddlePanel.add(this.maxDistanceField);
        this.advancedMiddlePanel.add(this.maxDistanceLimitLabel);
        this.advancedMiddlePanel.add(this.standardizationBox);
        this.advancedMiddlePanel.add(jButton2);
        this.advancedMiddlePanel.add(this.standardizationComboBox);
        this.advancedMiddlePanel.setBounds(0, 260, 690, 375);
        this.advancedMiddlePanel.setBackground(new Color(245, 245, 245));
    }

    protected void createBottomPanel() {
        JButton jButton = new JButton("Clear Values");
        JButton jButton2 = new JButton("Extract Microsatellites");
        jButton.setActionCommand("Clear Values");
        jButton2.setActionCommand("Extract Values");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton.setBounds(175, 10, 125, 20);
        jButton2.setBounds(310, 10, 205, 20);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(null);
        this.bottomPanel.add(jButton);
        this.bottomPanel.add(jButton2);
        this.bottomPanel.setBounds(0, 635, 690, 40);
        this.bottomPanel.setBackground(new Color(245, 245, 245));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser;
        int n;
        if (actionEvent.getActionCommand().equals("IMEx Mode") && !this.currentMode.equals(this.modeComboBox.getSelectedItem().toString())) {
            this.showScreenAgain(this.modeComboBox.getSelectedItem().toString());
        }
        if (actionEvent.getActionCommand().equals("Sequence File Browse") && (n = (jFileChooser = new JFileChooser()).showOpenDialog(this.mainFrame)) == 0) {
            this.sequenceFileLocationField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
        if (actionEvent.getActionCommand().equals("Sample Sequence")) {
            this.showSampleSequence();
        }
        if (actionEvent.getActionCommand().equals("Repeat Type") && !this.repeatTypeComboBox.getSelectedItem().toString().equals(this.currentRepeatType) && !this.currentMode.equals("Basic")) {
            int n2;
            if (this.repeatTypeComboBox.getSelectedItem().toString().equals("Perfect")) {
                for (n2 = 0; n2 < 6; ++n2) {
                    this.repeatNumberField[n2].setText("0");
                    this.imperfectionLimitComboBox[n2].setSelectedIndex(0);
                    this.repeatNumberField[n2].setEnabled(false);
                    this.imperfectionLimitComboBox[n2].setEnabled(false);
                }
                for (n2 = 0; n2 < (this.currentMode.equals("Intermediate") ? 1 : 6); ++n2) {
                    this.imperfectionPercentageComboBox[n2].setSelectedIndex(0);
                    this.imperfectionPercentageComboBox[n2].setEnabled(false);
                }
                this.currentRepeatType = "Perfect";
            } else {
                this.repeatNumberField[0].setText("15");
                this.repeatNumberField[1].setText("7");
                this.repeatNumberField[2].setText("5");
                this.repeatNumberField[3].setText("4");
                this.repeatNumberField[4].setText("3");
                this.repeatNumberField[5].setText("3");
                this.imperfectionLimitComboBox[0].setSelectedIndex(1);
                this.imperfectionLimitComboBox[1].setSelectedIndex(1);
                this.imperfectionLimitComboBox[2].setSelectedIndex(1);
                this.imperfectionLimitComboBox[3].setSelectedIndex(2);
                this.imperfectionLimitComboBox[4].setSelectedIndex(2);
                this.imperfectionLimitComboBox[5].setSelectedIndex(3);
                for (n2 = 0; n2 < 6; ++n2) {
                    this.repeatNumberField[n2].setEnabled(true);
                    this.imperfectionLimitComboBox[n2].setEnabled(true);
                }
                for (n2 = 0; n2 < (this.currentMode.equals("Intermediate") ? 1 : 6); ++n2) {
                    this.imperfectionPercentageComboBox[n2].setSelectedIndex(2);
                    this.imperfectionPercentageComboBox[n2].setEnabled(true);
                }
                this.currentRepeatType = "Imperfect";
            }
        }
        if (actionEvent.getActionCommand().equals("Ptt File Browse") && (n = (jFileChooser = new JFileChooser()).showOpenDialog(this.mainFrame)) == 0) {
            this.pttFileLocationField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
        if (actionEvent.getActionCommand().equals("Clear Values")) {
            this.showScreenAgain(this.currentMode);
        }
        if (actionEvent.getActionCommand().equals("Extract Values")) {
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "0";
            int n3 = 0;
            boolean bl = false;
            if (this.validate()) {
                Object object;
                int n4;
                int n5;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                this.mainFrame.setTitle("IMEx - Processing Sequence");
                this.mainFrame.repaint();
                if (this.sequenceFileUploadRadioButton.isSelected()) {
                    string2 = this.sequenceFileLocationField.getText();
                } else {
                    int n6 = 40960;
                    object5 = new byte[n6];
                    object4 = null;
                    object3 = null;
                    object3 = new File("temp");
                    if (!((File)object3).exists()) {
                        ((File)object3).mkdir();
                    }
                    bl = true;
                    object2 = new Random();
                    n3 = ((Random)object2).nextInt();
                    if (n3 < 0) {
                        n3 *= -1;
                    }
                    try {
                        object4 = new FileOutputStream("temp/seq_" + n3);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(this.mainFrame, "An I/O error occured while trying to create required files.", "Error", 0);
                    }
                    n5 = 0;
                    while (true) {
                        n4 = this.sequenceText.getText().substring(n5 * n6, n6 > this.sequenceText.getText().length() - n5 * n6 ? this.sequenceText.getText().length() : n5 * n6 + n6).length();
                        object5 = this.sequenceText.getText().substring(n5 * n6, n6 > this.sequenceText.getText().length() - n5 * n6 ? this.sequenceText.getText().length() : n5 * n6 + n6).getBytes();
                        if (n4 > 0) {
                            try {
                                ((FileOutputStream)object4).write((byte[])object5, 0, n4);
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog(this.mainFrame, "An I/O error occured while trying to create required files", "Error", 0);
                            }
                        }
                        if (n4 < n6) break;
                        ++n5;
                    }
                    try {
                        ((FileOutputStream)object4).close();
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(this.mainFrame, "An I/O error occured while trying to create required files", "Error", 0);
                    }
                    string2 = "temp/seq_" + n3;
                }
                if (this.pttFileUploadBox.isSelected()) {
                    string4 = "1";
                    string3 = " " + this.pttFileLocationField.getText();
                }
                if (this.currentMode.equals("Basic")) {
                    string = ((String)this.repeatTypeComboBox.getSelectedItem()).equals("Perfect") ? "./imex_batch " + string2 + " 0 0 0 0 0 0 0 0 0 0 0 0 15 7 5 4 3 3 10 1 0 " + string4 + " -1 -1 0" + string3 : "./imex_batch " + string2 + " 1 1 1 2 2 3 10 10 10 10 10 10 15 7 5 4 3 3 10 1 0 " + string4 + " -1 -1 0" + string3;
                } else if (this.currentMode.equals("Intermediate")) {
                    string = "./imex_batch " + string2;
                    for (n4 = 0; n4 < 6; ++n4) {
                        string = string + " ";
                        string = string + this.imperfectionLimitComboBox[n4].getSelectedItem().toString();
                    }
                    for (n4 = 0; n4 < 6; ++n4) {
                        string = string + " ";
                        string = string + this.imperfectionPercentageComboBox[0].getSelectedItem().toString().substring(0, this.imperfectionPercentageComboBox[0].getSelectedItem().toString().length() - 1);
                    }
                    for (n4 = 0; n4 < 6; ++n4) {
                        string = string + " ";
                        string = string + this.repeatNumberField[n4].getText();
                    }
                    string = string + " 10 1 0 " + string4 + " -1 -1 ";
                    string = string + this.repeatSizeComboBox.getSelectedIndex() + " " + string3;
                } else if (this.currentMode.equals("Advanced")) {
                    String string5 = this.flankingBox.isSelected() ? this.flankingComboBox.getSelectedItem().toString() : "0";
                    String string6 = this.alignmentBox.isSelected() ? "1" : "0";
                    object5 = this.textOutputBox.isSelected() ? (Object)"1" : (Object)"0";
                    object4 = "" + this.repeatSizeComboBox.getSelectedIndex();
                    object3 = this.compoundBox.isSelected() ? this.maxDistanceField.getText() : "-1";
                    object2 = this.standardizationBox.isSelected() ? "" + this.standardizationComboBox.getSelectedIndex() : "-1";
                    string = "./imex_batch " + string2;
                    for (n5 = 0; n5 < 6; ++n5) {
                        string = string + " ";
                        string = string + this.imperfectionLimitComboBox[n5].getSelectedItem().toString();
                    }
                    for (n5 = 0; n5 < 6; ++n5) {
                        string = string + " ";
                        string = string + this.imperfectionPercentageComboBox[n5].getSelectedItem().toString().substring(0, this.imperfectionPercentageComboBox[0].getSelectedItem().toString().length() - 1);
                    }
                    for (n5 = 0; n5 < 6; ++n5) {
                        string = string + " ";
                        string = string + this.repeatNumberField[n5].getText();
                    }
                    string = string + " " + string5 + " " + string6 + " " + (String)object5 + " " + string4 + " " + (String)object3 + " " + (String)object2 + " " + (String)object4 + string3;
                }
                Runtime runtime = Runtime.getRuntime();
                try {
                    object3 = runtime.exec(string);
                    object = ((Process)object3).getInputStream();
                    ((Process)object3).waitFor();
                    object5 = new byte[((InputStream)object).available()];
                    ((InputStream)object).read((byte[])object5);
                    ((InputStream)object).close();
                    object4 = new String((byte[])object5);
                    this.mainFrame.setTitle("IMEx");
                    this.mainFrame.repaint();
                    if (((String)object4).length() > 7 && ((String)object4).charAt(7) == '*') {
                        JOptionPane.showMessageDialog(this.mainFrame, ((String)object4).substring(7), "Processing complete", -1);
                    } else {
                        JOptionPane.showMessageDialog(this.mainFrame, "An error occured during processing.\n" + (String)object4, "Error", 0);
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.mainFrame, "An error occured during processing.\n" + exception, "Error", 0);
                }
                if (bl) {
                    object = new File("temp/seq_" + n3);
                    ((File)object).delete();
                }
                this.showScreenAgain(this.currentMode);
            }
        }
        if (actionEvent.getActionCommand().equals("Ptt Info")) {
            JOptionPane.showMessageDialog(this.mainFrame, "Protein Table File (.ptt)\n\nThe PTT file format is a table of protein features. A Protein Table (PTT) file contains the\nlocation, strand, length, ID, generic name, COG assignation and functional annotation for every\npredicted protein in whole genomes.\n\nThese protein table files, which end in a .ptt extension, can be obtained from NCBI's ftp site:\nftp://ftp.ncbi.nih.gov/genomes/.", "Protein Table File (.ptt)", 1);
        }
        if (actionEvent.getActionCommand().equals("Default Parameters Info")) {
            JOptionPane.showMessageDialog(this.mainFrame, "Default parameters of IMEx\n\nThe basic mode of IMEx uses the default parameters. The default parameters of IMEx are as follows:\n\nImperfection Limit/repeat unit : Mono: 1 Di: 1 Tri: 1 Tetra: 2 Penta: 2 Hexa: 3\nImperfection % of each tract : Mono: 10% Di: 10% Tri: 10% Tetra: 10% Penta: 10% Hexa: 10%\nMinimum Repeat Number : Mono: 5 Di: 2 Tri: 2 Tetra: 2 Penta: 2 Hexa: 2\n\nNote: For repeat type is perfect, the Imperfection limit / repeat unit and Imperfection percentage\nare all set to Zero (0) for all sizes.\nIf you want to use IMEx with different parameters you can\nuse either the \"Intermediate\" or \"Advanced\" mode.", "Default parameters of IMEx", 1);
        }
        if (actionEvent.getActionCommand().equals("Minimum Repeat Number Info")) {
            JOptionPane.showMessageDialog(this.mainFrame, "Minimum Repeat Number\n\nMinimum Repeat Number of a repeat tract is the number of repeat units in a tract so that it can be\nconsidered as a valid microsatellite tract.\n\nExample :\nFor example, for mono, if Min. Repeat Number is set to 15 means that only those mononucleotide\nrepeat tracts which contain atleast 15 nucleotides will be considered as a valid tract.", "Minimum Repeat Number", 1);
        }
        if (actionEvent.getActionCommand().equals("Imperfection Limit Info")) {
            JOptionPane.showMessageDialog(this.mainFrame, "Imperfection Limit/Repeat Unit\n\nImperfection Limit of a repeat size (Ex:tri,penta) is the number of point mutations (substitutions\nand indels) that can be allowed in a repeat unit (word) so that it can be considered as a match.\n\nExample :\nFor example, 2 words ATGC and ATGG can be considered as matching repeat units if the\nimperfection limit is 1 or more.", "Imperfection Limit/Repeat Unit", 1);
        }
        if (actionEvent.getActionCommand().equals("Imperfection Percentage Info")) {
            JOptionPane.showMessageDialog(this.mainFrame, "Imperfection Percentage\n\nImperfection percentage of a microsatellite repeat tract is the percentage of mismatches in the\nentire repeat tract. Imperfection percentage can be calculated as follows:\n\nFormula :\nImperfection Percentage = (No. of imperfections in entire tract / Total No. of Bases in tract) * 100", "Imperfection Percentage", 1);
        }
        if (actionEvent.getActionCommand().equals("dMax Info")) {
            JOptionPane.showMessageDialog(this.mainFrame, "dMAX : Maximum distance between SSRs allowed to consider as a cSSR\n\ndMAX is the maximum distance (threshold) between any two SSRs to become a potential Compound SSR.\nIMEx considers 2 or more SSRs as a single compound SSR if the distance between any two SSRs is\nless than or equal to the dMAX value set by the user.\n\nThe dMAX value can be bewteen 0 to 50.", "dMax", 1);
        }
        if (actionEvent.getActionCommand().equals("Standardization Info")) {
            JLabel jLabel = new JLabel("<html>Standardization Level<br><br>The Microsatellites and Compound Microsatellites in IMEx are standardized according<br>to the following Levels.<br><br>For Microsatellites:<br><br><pre><font face = 'Monospace' size = '5'>L0                           ATG<br>L1                       ATG TGA GAT<br>L2                 ATG TGA GAT CAT ATC TCA<br>L3           ATG TGA GAT CAT ATC TCA TAC ACT CTA<br>F     ATG TGA GAT CAT ATC TCA  TAC ACT CTA GTA TAG AGT</font></pre><br>For Compound Microsatellites:<br><br>No Standardization (L0) : No Standardization level indicates that the no specific<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;standardization is applied except that it checks only for exact matches.<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Example: 5' (ATGC)3-X3-(GCT)5 3' can be viewed as ATGC-X-GCT.<br><br>Level 1 Standardization (L1) : Along with exact match (L0), Level 1 Standardization<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;level looks for all possible combinations of each motif and reports as a match<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(Note: ATG repeat can also be viewed as TGA or GAT).<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Example: 5' (ATGC)3-X3-(GCT)5 3' can be viewed as TGCA-X-CTG.<br><br>Level 2 Standardization (L2) : Including L0 and L1, this considers the extact and all<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;possible combinations of the reverse compliment of the entire repeat and<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;reports as a match.<br><br>Full / Complete Standardization (F) : Including L0, L1 and L2, this considers the<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;compliment of the repeat and all possible combinations of the compliment and<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;reports as a match.<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Example: 5' (ATGC)3-X3-(GCT)5 3' can be viewed as TACG-X-CGA.</html>");
            JOptionPane.showMessageDialog(this.mainFrame, jLabel, "Standardization Level", 1);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItem() == this.sequenceFileUploadRadioButton && this.sequenceFileUploadRadioButton.isSelected()) {
            this.sequenceText.setEnabled(false);
            this.sequenceFileLocationField.setEnabled(true);
            this.sequenceFileUploadBrowseButton.setEnabled(true);
        }
        if (itemEvent.getItem() == this.pasteRadioButton && this.pasteRadioButton.isSelected()) {
            this.sequenceText.setEnabled(true);
            this.sequenceFileLocationField.setEnabled(false);
            this.sequenceFileUploadBrowseButton.setEnabled(false);
            this.sequenceText.grabFocus();
        }
        if (itemEvent.getItem() == this.flankingBox) {
            if (this.flankingBox.isSelected()) {
                this.flankingComboBox.setEnabled(true);
            } else {
                this.flankingComboBox.setEnabled(false);
            }
        }
        if (itemEvent.getItem() == this.pttFileUploadBox) {
            if (this.pttFileUploadBox.isSelected()) {
                this.pttFileLocationField.setEnabled(true);
                this.pttFileUploadBrowseButton.setEnabled(true);
            } else {
                this.pttFileLocationField.setEnabled(false);
                this.pttFileUploadBrowseButton.setEnabled(false);
            }
        }
        if (itemEvent.getItem() == this.compoundBox) {
            if (this.compoundBox.isSelected()) {
                this.maxDistanceField.setEnabled(true);
            } else {
                this.maxDistanceField.setEnabled(false);
            }
        }
        if (itemEvent.getItem() == this.standardizationBox) {
            if (this.standardizationBox.isSelected()) {
                this.standardizationComboBox.setEnabled(true);
            } else {
                this.standardizationComboBox.setEnabled(false);
            }
        }
    }

    private void showScreenAgain(String string) {
        if (string.equals("Basic") || string.equals("Intermediate") || string.equals("Advanced")) {
            this.mainFrame.remove(this.topPanel);
            this.mainFrame.remove(this.middlePanel);
            this.mainFrame.remove(this.bottomPanel);
            this.mainFrame.repaint();
            this.currentMode = string;
            this.createTopPanel();
            this.createBottomPanel();
            if (string.equals("Basic")) {
                this.createBasicMiddlePanel();
                this.middlePanel = this.basicMiddlePanel;
                this.modeComboBox.setSelectedIndex(0);
                this.bottomPanel.setBounds(0, 365, 690, 40);
                this.mainFrame.setSize(690, 430);
            } else if (string.equals("Intermediate")) {
                this.createIntermediateMiddlePanel();
                this.middlePanel = this.intermediateMiddlePanel;
                this.modeComboBox.setSelectedIndex(1);
                this.bottomPanel.setBounds(0, 455, 690, 40);
                this.mainFrame.setSize(690, 520);
            } else {
                this.createAdvancedMiddlePanel();
                this.middlePanel = this.advancedMiddlePanel;
                this.bottomPanel.setBounds(0, 635, 690, 40);
                this.mainFrame.setSize(690, 700);
            }
            this.mainFrame.add(this.topPanel);
            this.mainFrame.add(this.middlePanel);
            this.mainFrame.add(this.bottomPanel);
            this.mainFrame.validate();
            System.gc();
        }
    }

    private boolean validate() {
        int n;
        if (this.sequenceFileUploadRadioButton.isSelected() && this.sequenceFileLocationField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this.mainFrame, "NO INPUT PROVIDED!\n Please specify a valid sequence file", "Incomplete Input", 2);
            this.sequenceFileLocationField.grabFocus();
            return false;
        }
        if (this.pasteRadioButton.isSelected() && this.sequenceText.getText().length() == 0) {
            JOptionPane.showMessageDialog(this.mainFrame, "NO INPUT PROVIDED!\n Please paste a valid nucleotide sequence in the text area", "Incomplete Input", 2);
            this.sequenceText.grabFocus();
            return false;
        }
        if (this.pttFileUploadBox.isSelected() && this.pttFileLocationField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this.mainFrame, "Please specify a valid .ptt file", "Incomplete Input", 2);
            this.pttFileLocationField.grabFocus();
            return false;
        }
        if (!this.currentMode.equals("Basic")) {
            String string;
            boolean bl = false;
            for (n = 0; n < 6; ++n) {
                bl = false;
                string = this.repeatNumberField[n].getText();
                if (string.length() == 0) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Please specify a minimum repeat number for each motif lenth", "Incomplete Input", 2);
                    this.repeatNumberField[n].grabFocus();
                    return false;
                }
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) >= '0' && string.charAt(i) <= '9') continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            if (bl) {
                switch (n) {
                    case 0: {
                        JOptionPane.showMessageDialog(this.mainFrame, "Invalid Min. Repeat Number for Mono !!\n The value should include only numbers", "Invalid Input", 2);
                        break;
                    }
                    case 1: {
                        JOptionPane.showMessageDialog(this.mainFrame, "Invalid Min. Repeat Number for Di !!\n The value should include only numbers", "Invalid Input", 2);
                        break;
                    }
                    case 2: {
                        JOptionPane.showMessageDialog(this.mainFrame, "Invalid Min. Repeat Number for Tri !!\n The value should include only numbers", "Invalid Input", 2);
                        break;
                    }
                    case 3: {
                        JOptionPane.showMessageDialog(this.mainFrame, "Invalid Min. Repeat Number for Tetra !!\n The value should include only numbers", "Invalid Input", 2);
                        break;
                    }
                    case 4: {
                        JOptionPane.showMessageDialog(this.mainFrame, "Invalid Min. Repeat Number for Penta !!\n The value should include only numbers", "Invalid Input", 2);
                        break;
                    }
                    case 5: {
                        JOptionPane.showMessageDialog(this.mainFrame, "Invalid Min. Repeat Number for Hexa !!\n The value should include only numbers", "Invalid Input", 2);
                    }
                }
                this.repeatNumberField[n].setText("");
                this.repeatNumberField[n].grabFocus();
                return false;
            }
            for (n = 0; n < 6; ++n) {
                string = this.repeatNumberField[n].getText();
                if (Integer.parseInt(string) >= 2) continue;
                switch (n) {
                    case 0: {
                        JOptionPane.showMessageDialog(this.mainFrame, "Invalid Min. Repeat Number for Mono !!\n Repeat number should not be less than 2", "Invalid Input", 2);
                        break;
                    }
                    case 1: {
                        JOptionPane.showMessageDialog(this.mainFrame, "Invalid Min. Repeat Number for Di !!\n Repeat number should not be less than 2", "Invalid Input", 2);
                        break;
                    }
                    case 2: {
                        JOptionPane.showMessageDialog(this.mainFrame, "Invalid Min. Repeat Number for Tri !!\n Repeat number should not be less than 2", "Invalid Input", 2);
                        break;
                    }
                    case 3: {
                        JOptionPane.showMessageDialog(this.mainFrame, "Invalid Min. Repeat Number for Tetra !!\n Repeat number should not be less than 2", "Invalid Input", 2);
                        break;
                    }
                    case 4: {
                        JOptionPane.showMessageDialog(this.mainFrame, "Invalid Min. Repeat Number for Penta !!\n Repeat number should not be less than 2", "Invalid Input", 2);
                        break;
                    }
                    case 5: {
                        JOptionPane.showMessageDialog(this.mainFrame, "Invalid Min. Repeat Number for Hexa !!\n Repeat number should not be less than 2", "Invalid Input", 2);
                    }
                }
                this.repeatNumberField[n].setText("");
                this.repeatNumberField[n].grabFocus();
                return false;
            }
        }
        if (this.currentMode.equals("Advanced") && this.compoundBox.isSelected()) {
            String string = this.maxDistanceField.getText();
            if (string.length() == 0) {
                JOptionPane.showMessageDialog(this.mainFrame, "Please specify Compound SSR repeat interval", "Incomplete Input", 2);
                this.maxDistanceField.grabFocus();
                return false;
            }
            for (n = 0; n < string.length(); ++n) {
                if (string.charAt(n) >= '0' && string.charAt(n) <= '9') continue;
                JOptionPane.showMessageDialog(this.mainFrame, "Invalid Compound SSR repeat interval!!\n The value should be between 0-50", "Invalid Input", 2);
                this.maxDistanceField.setText("");
                this.maxDistanceField.grabFocus();
                return false;
            }
            if (Integer.parseInt(string) < 0 || Integer.parseInt(string) > 50) {
                JOptionPane.showMessageDialog(this.mainFrame, "Invalid Compound SSR repeat interval!!\n The value should be between 0-50", "Invalid Input", 2);
                this.maxDistanceField.setText("");
                this.maxDistanceField.grabFocus();
                return false;
            }
        }
        return true;
    }

    private void showSampleSequence() {
        FileInputStream fileInputStream = null;
        int n = 28020;
        int n2 = 0;
        byte[] byArray = new byte[n];
        try {
            fileInputStream = new FileInputStream("sample/sample_sequence.txt");
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.mainFrame, "Unable to access sample sequence", "Error", 0);
            return;
        }
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Monospaced", 0, 14));
        jTextArea.setEditable(false);
        jTextArea.setText("");
        do {
            try {
                n2 = fileInputStream.read(byArray, 0, n);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.mainFrame, "Unable to access sample sequence", "Error", 0);
            }
            jTextArea.setText(jTextArea.getText() + new String(byArray, 0, n2));
        } while (n2 >= n);
        try {
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBounds(0, 0, 660, 600);
        JFrame jFrame = new JFrame("Sample Sequence");
        jFrame.setLayout(null);
        jFrame.setDefaultCloseOperation(2);
        jFrame.add(jScrollPane);
        jFrame.setBounds(50, 10, 665, 625);
        jFrame.setResizable(false);
        jFrame.setLocationRelativeTo(this.mainFrame);
        jFrame.setVisible(true);
    }
}

